IF EXISTS (SELECT
						 *
					 FROM
						 SYS.VIEWS
					 WHERE
						OBJECT_ID = OBJECT_ID(N'[DBO].[V_EST_PROD_COMPRAS_LEAD_TIME]'))
	DROP VIEW [DBO].[V_EST_PROD_COMPRAS_LEAD_TIME]

GO
CREATE VIEW V_EST_PROD_COMPRAS_LEAD_TIME AS
SELECT
	EST_PROD_FABRIC.CD_FABRIC,
	NM_FABRIC,
	EST_COMPRADOR.NM_COMPRADOR,
	EST_PROD_FABRIC.LEAD_TIME,
	EST_PROD_FABRIC.FREQ_REV,
	DT_PROC_LEAD_TIME,
	CASE WHEN  FREQ_REV = 1 THEN
		2
	WHEN FREQ_REV = 2 THEN
		3
	WHEN FREQ_REV = 4 THEN
		4
	WHEN FREQ_REV = 8 THEN
		6
	WHEN FREQ_REV = 12 THEN
		8
	WHEN FREQ_REV = 28 THEN
		12
	END QTDE_PEDIDOS_ANALISADOS,
	'AGENDA FABRICANTE' AS TIPO_PROCESSO
FROM
	EST_PROD_FABRIC INNER JOIN EST_COMPRADOR ON
	EST_PROD_FABRIC.CD_EMP= EST_COMPRADOR.CD_EMP AND
	EST_PROD_FABRIC.CD_COMPRADOR=EST_COMPRADOR.CD_COMPRADOR
WHERE
	INDICADOR_SUPRIMENTO=1
UNION ALL
SELECT
	EST_PROD_FABRIC_GRUPO.CD_CTR_GRUPO,
	NM_GRUPO,
	EST_COMPRADOR.NM_COMPRADOR,
	EST_PROD_FABRIC_GRUPO.LEAD_TIME,
	EST_PROD_FABRIC_GRUPO.FREQ_REV,
	DT_PROC_LEAD_TIME,
	CASE WHEN  FREQ_REV = 1 THEN
		2
	WHEN FREQ_REV = 2 THEN
		3
	WHEN FREQ_REV = 4 THEN
		4
	WHEN FREQ_REV = 8 THEN
		6
	WHEN FREQ_REV = 12 THEN
		8
	WHEN FREQ_REV = 28 THEN
		12
	END QTDE_PEDIDOS_ANALISADOS,
	'AGENDA GRUPO DE COMPRAS' AS TIPO_PROCESSO
FROM
	EST_PROD_FABRIC_GRUPO INNER JOIN EST_COMPRADOR ON
	1= EST_COMPRADOR.CD_EMP AND
	EST_PROD_FABRIC_GRUPO.CD_COMPRADOR=EST_COMPRADOR.CD_COMPRADOR
WHERE
	INDICADOR_SUPRIMENTO=1